// hash.java
// demonstracja tablicy rozproszonej z sondowaniem liniowym
// aby uruchomi program: C:>java HashTableApp (wersja angielska)
// aby skompilowa wersj polsk: C>javac hash.java
// po kompilacji:         C>java HashTableApp
import java.io.*;
////////////////////////////////////////////////////////////////
class DataItem
   {                                // (moe mie wicej danych)
   private int iData;               // element danych (klucz)
//--------------------------------------------------------------
   public DataItem(int ii)          // konstruktor
      { iData = ii; }
//--------------------------------------------------------------
   public int getKey()
      { return iData; }
//--------------------------------------------------------------
   }  // end class DataItem
////////////////////////////////////////////////////////////////
class HashTable
   {
   private DataItem[] hashArray;    // tablica rozproszona
   private int arraySize;
   private DataItem nonItem;        // do usuwania elementw
// -------------------------------------------------------------
   public HashTable(int size)       // konstruktor
      {
      arraySize = size;
      hashArray = new DataItem[arraySize];
      nonItem = new DataItem(-1);   // klucz elementu usunitego to -1
      }
// -------------------------------------------------------------
   public void displayTable()
      {
      System.out.print("Tablica: ");
      for(int j=0; j<arraySize; j++)
         {
         if(hashArray[j] != null)
            System.out.print(hashArray[j].getKey() + " ");
         else
            System.out.print("** ");
         }
      System.out.println("");
      }
// -------------------------------------------------------------
   public int hashFunc(int key)
      {
      return key % arraySize;       // funkcja rozpraszajca
      }
// -------------------------------------------------------------
   public void insert(DataItem item) // wstaw DataItem
   // (zakadamy, e tablica nie jest pena)
      {
      int key = item.getKey();      // pobierz klucz
      int hashVal = hashFunc(key);  // oblicz warto indeksu dla klucza
                                    // powtarzaj do pustej lub -1,
      while(hashArray[hashVal] != null &&
                      hashArray[hashVal].getKey() != -1)
         {
         ++hashVal;                 // przejd do nastpnej komrki
         hashVal %= arraySize;      // jeli trzeba, przejd na pocztek tablicy
         }
      hashArray[hashVal] = item;    // wstaw element
      }  // end insert()
// -------------------------------------------------------------
   public DataItem delete(int key)  // usu DataItem
      {
      int hashVal = hashFunc(key);  // oblicz warto indeksu dla klucza

      while(hashArray[hashVal] != null)  // powtarzaj do pustej,
         {                               // czy klucz zosta znaleziony?
         if(hashArray[hashVal].getKey() == key)
            {
            DataItem temp = hashArray[hashVal]; // zapisz element danych
            hashArray[hashVal] = nonItem;       // usu element
            return temp;                        // zwr element
            }
         ++hashVal;                 // przejd do nastpnej komrki
         hashVal %= arraySize;      // jeli trzeba, przejd na pocztek tablicy
         }
      return null;                  // elementu nie znaleziono
      }  // end delete()
// -------------------------------------------------------------
   public DataItem find(int key)    // znajd element o okrelonym kluczu
      {
      int hashVal = hashFunc(key);  // oblicz warto indeksu dla klucza

      while(hashArray[hashVal] != null)  // powtarzaj do pustej,
         {                               // czy klucz zosta znaleziony?
         if(hashArray[hashVal].getKey() == key)
            return hashArray[hashVal];   // tak, zwr element
         ++hashVal;                 // przejd do nastpnej komrki
         hashVal %= arraySize;      // jeli trzeba, przejd na pocztek tablicy
         }
      return null;                  // elementu nie znaleziono
      }
// -------------------------------------------------------------
   }  // end class HashTable
////////////////////////////////////////////////////////////////
class HashTableApp
   {
   public static void main(String[] args) throws IOException
      {
      DataItem aDataItem;
      int aKey, size, n, keysPerCell;
                                    // pobierz rozmiary
      System.out.print("Wprowad rozmiar tablicy rozproszonej: ");
      size = getInt();
      System.out.print("Wprowad pocztkow liczb elementw: ");
      n = getInt();
      keysPerCell = 10;
                                    // utwrz tablic
      HashTable theHashTable = new HashTable(size);

      for(int j=0; j<n; j++)        // wstaw dane
         {
         aKey = (int)(java.lang.Math.random() *
                                         keysPerCell * size);
         aDataItem = new DataItem(aKey);
         theHashTable.insert(aDataItem);
         }

      while(true)                   // cz interakcyjna
         {
         System.out.print("Wprowad pierwsz liter  ");
         System.out.print("Poka, Wstaw, Usu, lub Znajd: ");
         char choice = getChar();
         switch(choice)
            {
            case 'p':
               theHashTable.displayTable();
               break;
            case 'w':
            System.out.print("Wprowad warto klucza: ");
               aKey = getInt();
               aDataItem = new DataItem(aKey);
               theHashTable.insert(aDataItem);
               break;
            case 'u':
               System.out.print("Wprowad warto klucza usuwanego elementu: ");
               aKey = getInt();
               theHashTable.delete(aKey);
               break;
            case 'z':
               System.out.print("Wprowad warto klucza elementu do wyszukania: ");
               aKey = getInt();
               aDataItem = theHashTable.find(aKey);
               if(aDataItem != null)
                  {
                  System.out.println("Znaleziono " + aKey);
                  }
               else
                  System.out.println("Nie znaleziono " + aKey);
               break;
            default:
               System.out.print("Wcisne niewaciwy klawisz\n");
            }  // end switch
         }  // end while
      }  // end main()
//--------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//--------------------------------------------------------------
   public static char getChar() throws IOException
      {
      String s = getString();
      return s.charAt(0);
      }
//-------------------------------------------------------------
   public static int getInt() throws IOException
      {
      String s = getString();
      return Integer.parseInt(s);
      }
//--------------------------------------------------------------
   }  // end class HashTableApp
////////////////////////////////////////////////////////////////
